[Setup]
AppName=SoundResourceDemo
AppVerName=1.0
DefaultDirName={pf}\SoundResourceDemo
OutputDir=Output

RawDataResource=SndA:bugreporter_succeeded.wav |SndB:buttonclickreleaseo.WAV


[code]
#define A = (Defined UNICODE) ? "W" : "A"

type
    HINST = THandle;
    HMODULE = HINST;
    Pointer = Longint;
    HRSRC = THandle;
    HGLOBAL = THandle;

const
    SND_ASYNC           = $0001;
    SND_NODEFAULT       = $0002;
    SND_MEMORY          = $0004;
    RT_RCDATA           = 10;


function sndPlaySound(lpszSoundName: Pointer; uFlags: UINT): BOOL; external 'sndPlaySound{#A}@Winmm.dll stdcall';
function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL; external 'LoadResource@kernel32.dll stdcall';
function FindResource(hModule: HMODULE; lpName: String; lpType: Longint): HRSRC; external 'FindResource{#A}@kernel32.dll stdcall';
function LockResource(hResData: HGLOBAL): Pointer; external 'LockResource@kernel32.dll stdcall';



var
    hResourceSound: HRSRC;
    pSoundMemory: Pointer;

procedure InitializeWizard();
begin
    hResourceSound := FindResource(HInstance, '_IS_SNDA', RT_RCDATA);
    pSoundMemory := LockResource(LoadResource(HInstance, hResourceSound));
    sndPlaySound(pSoundMemory, SND_MEMORY or SND_NODEFAULT or SND_ASYNC);
end;




